/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitExecutable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public final class PortableGit {
    private static IPath location;
    private static boolean locationInitialized;

    static {
        locationInitialized = false;
    }

    private PortableGit() {
    }

    public static IPath getLocation() {
        if (locationInitialized) {
            return location;
        }
        locationInitialized = true;
        Bundle bundle = PortableGit.getBundle();
        if (bundle != null) {
            IPath path = Platform.getStateLocation((Bundle)bundle);
            if (path != null) {
                path = path.append("bin").append("git.exe");
            }
            if (path != null && GitExecutable.acceptBinary(path)) {
                location = path;
                return location;
            }
        }
        return null;
    }

    protected static void checkInstallation(IPath location) {
        Bundle bundle = PortableGit.getBundle();
        if (bundle != null) {
            IPath path = Platform.getStateLocation((Bundle)bundle);
            if (path != null) {
                path = path.append("bin").append("git.exe");
            }
            if (path != null && path.equals((Object)location)) {
                Job job = new Job("Check PortableGit installation"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            PortableGit.getBundle().start(1);
                        }
                        catch (BundleException e) {
                            IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                        }
                        return Status.OK_STATUS;
                    }
                };
                EclipseUtil.setSystemForJob((Job)job);
                job.setPriority(30);
                job.schedule();
            }
        }
    }

    public static void install() {
        Bundle bundle = PortableGit.getBundle();
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start(1);
                locationInitialized = false;
            }
            catch (BundleException e) {
                IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    private static Bundle getBundle() {
        return Platform.getBundle((String)("com.aptana.portablegit." + Platform.getOS()));
    }
}

